uniform vec2 center; 
uniform vec2 resolution;
uniform float time;
uniform vec2 mouse; 
uniform float pulse1;
uniform float pulse2;
uniform float pulse3; 






void main(){
	
	
	

	vec2 p = (2.0*gl_FragCoord.xy-resolution.xy)/resolution.y;

    float a = atan(p.x,p.y);
    float r = length(p);
    vec2 uv = vec2(a/(2.0 * 3.1415926535),r);
	
	
	
	float xCol = (uv.x - (time / 8.0)) * 3.0;
	xCol = mod(xCol, 3.0);
	vec3 horColour = vec3(0.25, 0.25, 0.25);
	
	if (xCol < 1.0) {
		
		horColour.r += 1.0 - xCol;
		horColour.g += xCol;
	}
	else if (xCol < 2.0) {
		
		xCol -= 1.0;
		horColour.g += 1.0 - xCol;
		horColour.b += xCol;
	}
	else {
		
		xCol -= 2.0;
		horColour.b += 1.0 - xCol;
		horColour.r += xCol;
	}
	
	
	float backValue = 1.0;
	float aspect = resolution.x / resolution.y;
	if (mod(uv.y * 100.0, 1.0) > 0.75 || mod(uv.x * 100.0 * aspect, 1.0) > 0.75) {
		
		backValue = 1.15;	
	}
	
	vec3 backLines  = vec3(backValue);
	
	
	uv = (2.0 * uv) - 1.0;
	float beamWidth = abs(3.0 / (30.0 * uv.y));
	vec3 horBeam = vec3(beamWidth);
	
	gl_FragColor = vec4(((backLines * horBeam) * horColour), 1.0);
}